﻿
//The following variables are declared in Views\PatientProfile\Index.cshtml

//var attachedPdfCount
//const MaxTotalSizeOfAttachedPdfs
//const MaxSizeOfAttachedPdf
//var sizeOfAttachedPdfs
//const MaxNumberOfAttachedPdfs


var pdfsToAttachCount = 0;
var removedPdfCount = 0;

function removePdf(rowNumber, size) {
    $("#pdfUploadLabelAndInput" + rowNumber).remove();
    $("#pdfRow" + rowNumber).remove();
    removedPdfCount++;
    sizeOfAttachedPdfs -= size;
    if (removedPdfCount >= (attachedPdfCount + pdfsToAttachCount - 1)) {
        $("#attachedPdfList").hide();
        var inputId = "#PdfsToAttach" + pdfsToAttachCount;
        $(inputId).focus();
    }
    var inputId = "#PdfsToAttach" + pdfsToAttachCount;
    $(inputId).focus();
}

function removeAttachedPdf(rowNumber, size) {
    $("#attachedPdfRow" + rowNumber).hide();
    $("#AttachedPdfs_" + rowNumber + "__Remove").val("true");
    removedPdfCount++;
    sizeOfAttachedPdfs -= size;
    if (removedPdfCount >= (attachedPdfCount + pdfsToAttachCount - 1)) {
        $("#attachedPdfList").hide();
    }
}

$(document).ready(function () {

    function insertAdditionalFileInput() {
        pdfsToAttachCount++;
        var inputId = "PdfsToAttach" + pdfsToAttachCount;
        $("#pdfInputs").append('<div class="pdfUploadLabelAndInput" id="pdfUploadLabelAndInput' + pdfsToAttachCount + '">'
            + '<label for="' + inputId + '" class="visual-label" aria-hidden="true">Attach a PDF:</label>'
            + '<input class="attach-pdf-input" type="file" name="PdfsToAttach" id="' + inputId + '" aria-label="Select an additional PDF to attach to the RefDoc package (optional). After you select a PDF, you must click on the &quot;Confirm attachment&quot; button below to attach the PDF." /></div>');
    }

    insertAdditionalFileInput();

    if (attachedPdfCount > 0) {
        $("#attachedPdfList").show();
    }

    //Credit for this function goes to dvijaz from his/her answer at https://stackoverflow.com/a/14852935
    function validatePdf(fileInputId) {
        // get the file name, possibly with path (depends on browser)
        var filename = $("#" + fileInputId).val();

        // Use a regular expression to trim everything before final dot
        var extension = filename.replace(/^.*\./, '');

        // Iff there is no dot anywhere in filename, we would have extension == filename,
        // so we account for this possibility now
        if (extension == filename) {
            extension = '';
        } else {
            // if there is an extension, we convert to lower case
            // (N.B. this conversion will not effect the value of the extension
            // on the file upload.)
            extension = extension.toLowerCase();
        }

        switch (extension) {
            case 'pdf':
                return true;
            default:
                return false;
        }
    }

    function validatePdfSize(fileInputId) {
        // get the file name, possibly with path (depends on browser)
        var filename = $("#" + fileInputId).val();

        // Use a regular expression to trim everything before final dot
        var extension = filename.replace(/^.*\./, '');

        // Iff there is no dot anywhere in filename, we would have extension == filename,
        // so we account for this possibility now
        if (extension == filename) {
            extension = '';
        } else {
            // if there is an extension, we convert to lower case
            // (N.B. this conversion will not effect the value of the extension
            // on the file upload.)
            extension = extension.toLowerCase();
        }

        switch (extension) {
            case 'pdf':
                return true;
            default:
                return false;
        }
    }

    function pdfSizeIsWithinLimit(pdfFile) {
        if (pdfFile.size <= MaxSizeOfAttachedPdf) {
            return true;
        }
        return false;
    }

    function totalSizeOfAllPdfsIsWithinLimit(pdfFile) {
        if ((pdfFile.size + sizeOfAttachedPdfs) <= MaxTotalSizeOfAttachedPdfs) {
            return true;
        }
        return false;
    }

    function numberOfAttachedPdfsIsWithinLimit() {
        return (pdfsToAttachCount + attachedPdfCount - removedPdfCount) <= MaxNumberOfAttachedPdfs;
    }

    function insertPdfRow(pdfFile) {
        var sizeInMB = Math.round(pdfFile.size / 10486) / 100;

        $("#attachedPdfList tbody").append('<tr id="pdfRow' + pdfsToAttachCount + '"><td>'
            + pdfFile.name + '</td><td>'
            + sizeInMB + ' MB</td><td style="border:none"><a href="#" onkeydown="javascript: if(event.keyCode == 13) removePdf(' + pdfsToAttachCount + ', ' + pdfFile.size + ');" onclick="removePdf(' + pdfsToAttachCount + ', ' + pdfFile.size + ')" role="button" aria-label="Remove ' + pdfFile.name + '"><img alt="Remove button." src="/Content/Images/remove.png" class="removePdfButton" pdfrownumber="' + pdfsToAttachCount + '"/></a></td></tr>');
    }

    $("#attachPdf").on("click", function (e) {
        var currentFileInputId = "PdfsToAttach" + pdfsToAttachCount;
        var currentInputAndLabelId = 'pdfUploadLabelAndInput' + pdfsToAttachCount;
        if (!$("#" + currentFileInputId)[0].files[0]) {
            return;
        }
        var pdfFile = $("#" + currentFileInputId)[0].files[0];
        if (!validatePdf(currentFileInputId)) {
            $("#nonPdfErrorMessage").show();
            $("#" + currentFileInputId).val('');
            $("#pdfTooLargeMessage").hide();
            $("#totalSizeOfPdfsTooLargeMessage").hide();
            $("#tooManyPdfsMessage").hide();
        }
        else if (!pdfSizeIsWithinLimit(pdfFile)) {
            $("#pdfTooLargeMessage").show();
            $("#" + currentFileInputId).val('');
            $("#nonPdfErrorMessage").hide();
            $("#totalSizeOfPdfsTooLargeMessage").hide();
            $("#tooManyPdfsMessage").hide();
        }
        else if (!totalSizeOfAllPdfsIsWithinLimit(pdfFile)) {
            $("#totalSizeOfPdfsTooLargeMessage").show();
            $("#" + currentFileInputId).val('');
            $("#nonPdfErrorMessage").hide();
            $("#pdfTooLargeMessage").hide();
            $("#tooManyPdfsMessage").hide();
        }
        else if (!numberOfAttachedPdfsIsWithinLimit()) {
            $("#tooManyPdfsMessage").show();
            $("#" + currentFileInputId).val('');
            $("#nonPdfErrorMessage").hide();
            $("#pdfTooLargeMessage").hide();
            $("#totalSizeOfPdfsTooLargeMessage").hide();
        }
        else {
            $("#" + currentInputAndLabelId).hide();
            $("#nonPdfErrorMessage").hide();
            $("#pdfTooLargeMessage").hide();
            $("#totalSizeOfPdfsTooLargeMessage").hide();
            sizeOfAttachedPdfs += pdfFile.size;
            $("#attachedPdfList").show();
            insertPdfRow(pdfFile);
            insertAdditionalFileInput();
            $("#attachPdf").attr('aria-disabled', 'true');
            $("#attachPdf").attr('aria-label', 'Confirm Attachment. Button is enabled after you select a file using the file input above.');
            var inputId = "#PdfsToAttach" + pdfsToAttachCount;
            $(inputId).focus();
        }
    });

    $('#attachPdf').keypress(function (e) {
        if (e.which == 13) {
            $('#attachPdf').click();
        }
    });

    $('.attach-pdf-input').change(function (e) {
        var inputId = "#PdfsToAttach" + pdfsToAttachCount;

        if ($(inputId).val() == '') {
            $("#attachPdf").attr('aria-disabled', 'true');
            $("#attachPdf").attr('aria-label', 'Confirm Attachment. Button is enabled after you select a file using the file input above.');
        }
        else {
            $("#attachPdf").removeAttr('aria-disabled');
            $("#attachPdf").attr('aria-label', 'Confirm attachment. Once you confirm, you will be able to select another PDF using the file input above. Additionally, the attached PDF will appear in table below.');
        }

    });

})